#!/c/Perl/bin//perl -w
#
# $Id: idxdiff-1.pl.in,v 1.1.4.2 2006/01/10 19:37:18 opengl2772 Exp $
# Copyright (C) 2004-2006 Tadamasa Teranishi
#               2004-2006 Namazu Project All rights reserved.
#     This is free software with ABSOLUTELY NO WARRANTY.
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either versions 2, or (at your option)
#  any later version.
#
#  This program is distributed in the hope that it will be useful
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
#  02111-1307, USA
#
#  This file must be encoded in EUC-JP encoding
#
#

#
# Check whether idx1 and idx2 indices are same.
#
# idx1: simply indexed.
# idx2: incrementally indexed.
#

use strict;
require Cwd;
use File::Compare;
use File::Basename;
require 'pltests.pl';

my $cwd = Cwd::cwd();
my $LOG = "$cwd/test-log";
my $INDEX = "$cwd/idx1";
my $INDEX2 = "$cwd/idx2";

pltests::putline($LOG, "  *** starting $0");

my @targets = ();
for my $file (<$INDEX/NMZ.*>) {
    if ($file !~ /NMZ\.(?:log|r|slog|status|err)$/s) {
        push @targets, basename($file);
    }
}

if ($#targets == -1) {
    exit 1;
}

my $stat = 0;
for my $file (@targets) {
    if (compare("$INDEX/$file", "$INDEX2/$file") != 0) {
        pltests::putline($LOG, "diff $INDEX/$file $INDEX2/$file");
        $stat = 1;
    }
}

exit $stat;
